//
//  PMAboutUsController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/19.
//

import UIKit
import MessageUI

class PMAboutUsController: BaseViewController, MFMailComposeViewControllerDelegate {

    @IBOutlet weak var despLabel: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        titleView.model.title = "About Us"
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        setConfigs()
        addClick()
    }
    
    private func setConfigs() -> Void {
        var mutableText:NSMutableAttributedString = NSMutableAttributedString(attributedString: despLabel.attributedText ?? NSMutableAttributedString(string: ""))
        let paragraph = NSMutableParagraphStyle()
        paragraph.lineSpacing = 2
        mutableText.addAttributes([NSAttributedString.Key.paragraphStyle : paragraph], range: NSRange(location: 0, length: mutableText.length))
        if let rang = mutableText.string.range(of: "OUR APPROACH") {
            let startIndex = rang.lowerBound
            let endIndex = rang.upperBound
            let start = mutableText.string.distance(from: mutableText.string.startIndex, to: startIndex)
            let end = mutableText.string.distance(from: mutableText.string.startIndex, to: endIndex)
            mutableText.addAttributes([NSAttributedString.Key.font : UIFont.systemFont(ofSize: 16, weight: .bold)], range: NSRange(location: start, length: end - start))
        }
        if let rang = mutableText.string.range(of: "apps.columbusdev.com") {
            let startIndex = rang.lowerBound
            let endIndex = rang.upperBound
            let start = mutableText.string.distance(from: mutableText.string.startIndex, to: startIndex)
            let end = mutableText.string.distance(from: mutableText.string.startIndex, to: endIndex)
            mutableText.addAttributes([NSAttributedString.Key.font : UIFont.systemFont(ofSize: 14, weight: .regular),NSAttributedString.Key.foregroundColor:UIColor.colorWithHex(hexStr: "#0082FF"),.underlineStyle:NSUnderlineStyle.single.rawValue,.underlineColor:UIColor.colorWithHex(hexStr: "#0082FF")],
                                      range: NSRange(location: start, length: end - start))
        }
        if let rang = mutableText.string.range(of: "ligaili1217@163.com") {
            let startIndex = rang.lowerBound
            let endIndex = rang.upperBound
            let start = mutableText.string.distance(from: mutableText.string.startIndex, to: startIndex)
            let end = mutableText.string.distance(from: mutableText.string.startIndex, to: endIndex)
            mutableText.addAttributes([NSAttributedString.Key.font : UIFont.systemFont(ofSize: 14, weight: .regular),NSAttributedString.Key.foregroundColor:UIColor.colorWithHex(hexStr: "#0082FF"),.underlineStyle:NSUnderlineStyle.single.rawValue,.underlineColor:UIColor.colorWithHex(hexStr: "#0082FF")],
                                      range: NSRange(location: start, length: end - start))
        }
        despLabel.attributedText = mutableText
    }

    
    private func addClick() -> Void {
        let click = ["apps.columbusdev.com","ligaili1217@163.com"]
        despLabel.AddTapped(click) {[weak self] text in
            guard let self = self else { return }
            if text == click[0] {
                guard let url = URL(string: "https://apps.columbusdev.com/") else { return }
                UIApplication.shared.open(url)
            }else{
                self.sendMail()
            }
        }
    }
    
    private func sendMail() -> Void {
        let email = "ligaili1217@163.com"
        let subject = ""//邮件主题
        let body = ""//邮件正文
        let defaultURL = URL(string: "mailto:\(email)?subject=\(subject)&body=\(body)")
        let application = UIApplication.shared
        if let url = defaultURL,application.canOpenURL(url) {
            application.open(url)
        }else{
            print("Unable to send email")
            PMAlert(title: nil, messsage: "", action: ["Ok"])
        }
    }
    
    func mailComposeController(_ controller: MFMailComposeViewController, didFinishWith result: MFMailComposeResult, error: (any Error)?) {
        controller.dismiss(animated: true)
    }
    
}
